//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "ImageListSet.h"
//#include "resource.h"

void ToolBarIcons::init(ToolBarButtonUnit *buttonUnitArray, int arraySize)
{
	for (int i = 0 ; i < arraySize ; i++)
		_tbiis.push_back(buttonUnitArray[i]);
}

void ToolBarIcons::create(HINSTANCE hInst, int iconSize)
{
	_iconListVector.push_back(IconList());
	_iconListVector.push_back(IconList());
	_iconListVector.push_back(IconList());

	_iconListVector[HLIST_DEFAULT].create(hInst, iconSize);
	_iconListVector[HLIST_HOT].create(hInst, iconSize);
	_iconListVector[HLIST_DISABLE].create(hInst, iconSize);

	for (int i = 0 ; i < int(_tbiis.size()) ; i++)
	{
		_cmdArray[_nbCmd++] = _tbiis[i]._cmdID;
		if (_tbiis[i]._defaultIcon != IDI_SEPARATOR_ICON)
		{
			_iconListVector[HLIST_DEFAULT].addIcon(_tbiis[i]._defaultIcon);
			_iconListVector[HLIST_HOT].addIcon(_tbiis[i]._hotIcon);
			_iconListVector[HLIST_DISABLE].addIcon(_tbiis[i]._grayIcon);
		}
	}
}

void ToolBarIcons::destroy()
{
	_iconListVector[HLIST_DEFAULT].destroy();
	_iconListVector[HLIST_HOT].destroy();
	_iconListVector[HLIST_DISABLE].destroy();
}
