//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
const char cInstrWords[] = "if else switch case default break goto return for while do continue typedef sizeof NULL";
const char cppInstrWords[] = "new delete throw try catch namespace operator this const_cast static_cast dynamic_cast reinterpreter_cast true false null";
const char javaInstrWords[] = "new delete throw throws try catch finally this super extends implements import true false null";

const char rcInstrWords[] = "ACCELERATORS ALT AUTO3STATE AUTOCHECKBOX AUTORADIOBUTTON "
							"BEGIN BITMAP BLOCK BUTTON CAPTION CHARACTERISTICS CHECKBOX CLASS "
							"COMBOBOX CONTROL CTEXT CURSOR DEFPUSHBUTTON DIALOG DIALOGEX DISCARDABLE "
							"EDITTEXT END EXSTYLE FONT GROUPBOX ICON LANGUAGE LISTBOX LTEXT "
							"MENU MENUEX MENUITEM MESSAGETABLE POPUP "
							"PUSHBUTTON RADIOBUTTON RCDATA RTEXT SCROLLBAR SEPARATOR SHIFT STATE3 "
							"STRINGTABLE STYLE TEXTINCLUDE VALUE VERSION VERSIONINFO VIRTKEY ";


const char cTypeWords[] = "void struct union enum char short int long double float signed unsigned const static extern auto register volatile";
const char cppTypeWords[] = "bool class private protected public friend inline template virtual";
const char javaTypeWords[] = "byte boolean class interface native private protected public final abstract synchronized";


const char htmlKeyWords[] = "a abbr acronym address applet area b base basefont "
							"bdo big blockquote body br button caption center "
							"cite code col colgroup dd del dfn dir div dl dt em "
							"fieldset font form frame frameset h1 h2 h3 h4 h5 h6 "
							"head hr html i iframe img input ins isindex kbd label "
							"legend li link map menu meta noframes noscript "
							"object ol optgroup option p param pre q s samp "
							"script select small span strike strong style sub sup "
							"table tbody td textarea tfoot th thead title tr tt u ul "
							"var xml xmlns"
							"accept-charset accept accesskey action align alink "
							"alt archive axis background bgcolor border "
							"cellpadding cellspacing char charoff charset checked cite "
							"class classid clear codebase codetype color cols colspan "
							"compact content coords "
							"data datafld dataformatas datapagesize datasrc datetime "
							"declare defer dir disabled enctype event "
							"face for frame frameborder "
							"headers height href hreflang hspace http-equiv "
							"id ismap label lang language leftmargin link longdesc "
							"marginwidth marginheight maxlength media method multiple "
							"name nohref noresize noshade nowrap "
							"object onblur onchange onclick ondblclick onfocus "
							"onkeydown onkeypress onkeyup onload onmousedown "
							"onmousemove onmouseover onmouseout onmouseup "
							"onreset onselect onsubmit onunload "
							"profile prompt readonly rel rev rows rowspan rules "
							"scheme scope selected shape size span src standby start style "
							"summary tabindex target text title topmargin type usemap "
							"valign value valuetype version vlink vspace width "
							"text password checkbox radio submit reset "
							"file hidden image public !doctype";

const char JSKeyWords[] = "if else for while function var";

const char PHPKeyWords[] = "and argv as argc break case cfunction class continue declare default do "
                            "die echo else elseif empty enddeclare endfor endforeach endif endswitch "
                            "endwhile e_all e_parse e_error e_warning eval exit extends false for "
                            "foreach function global http_cookie_vars http_get_vars http_post_vars "
                            "http_post_files http_env_vars http_server_vars if include include_once "
                            "list new not null old_function or parent php_os php_self php_version "
                            "print require require_once return static switch stdclass this true var "
                            "xor virtual while __file__ __line__ __sleep __wakeup";

// list MACOCS30 //
const char commandM30[] = "CALLFUNCTION CHECKSUM END ENTRANT GOTO LOCKREADER IF POWEROFF POWERON "
                          "SET SORTANT STATUSPERSO SWITCH UNLOCKREADER";

const char macroM30[]  = "ChangeCode CipherData CreateBinary CreateBinaryCipher CreateDirectoryV1 "
                         "CreateDirectoryV3 CreateFile CreateFilePlein00 CreateFilePleinFF CreateFileSMS "
                         "CreateFileVide CreateRecord CreateRecordCipher Delete DeleteFile DisableChv "
                         "EnableChv Envelope Fetch GenerateKey GetData GetResponse GetStatus Increase "
                         "Install InstallLoad Invalidate KeyCalculus LastLoad Load LockRecord "
                         "MultiCreateBinary MultiCreateRecord MultiLoad MultiUpdateBinary MultiUpdateRecord "
                         "PutData ReadBinary ReadDirectory ReadRecord Rehabilitate RsaInitKeyList RsaAddKeyToList "
                         "RsaSendRequest RsaGetPublicKeyVal RsaGetKeyModulusHash RsaGetAndCutPrivateKeyValue "
                         "RsaWritePrivateKey SetLock SetStatus SelectDF SelectEF Set Sleep StatusCard UpdateBinary "
                         "UpdateBinary2 UpdateRecord UnblockCode VerifyCode VerifyDisabled";

const char commandLabel[] = "ARG1 ARG2 CMD_ISO COMP CIBLE DATA DEST ELSE ETAT FREQ "
                            "IDFUNC LABEL OP PTS SECURITE SOURCE STATUS THEN";

const char macroLabel[] = "Blck Buf Cible CipherKey Cle ClearLen Code Compl CutLen "
                          "Data Dest Diversif DummyBuf ExponentVal FirstRec HiOffset "
                          "ID IndexInList KeyNumber Lg LgCre LgRec LgUp LoOffset "
                          "MaxLg Mode ModSel ModulusLen Nb NbRec NoRec Occur Offset Op "
                          "P1 P3 RBKey RBSize RecNum Source State Subset Target Tag1 Tag2 Type ULg";

// list Pcom //
const char pcomNativeCmd[] = "DEFINE POWER_ON POWER_OFF STEP_ON STEP_OFF LIST_ON LIST_OFF SET_BUFFER INSERT EJECT "
							 "ERROR_BEEP_ON ERROR_BEEP_OFF END_BEEP_ON END_BEEP_ON PATH READER CALL EXECUTE EXIT "
							 "BEGIN_LOOP LOOP INCREASE_BUFFER DECREASE_BUFFER APPEND_BUFFER UNDEFINE ALLUNDEFINE "
							 "IFDEF ELSE ENDIF IFNDEF LOAD UNLOAD";

const char pcomExtCmd[] = "SET_DATA DISPLAY COMPARE SET_RSA_LEN SET_RSA_NUB SET_RSA_NBITS COMPUTE_RSA_KEYS "
						  "GET_RSA_PUBLIC_KEYS GET_RSA_SIGNATURE VERIFY_RSA_SIGNATURE SHA SET_PRF_SECRET "
						  "SET_PRF_LABEL_SEED PRF SET_PRF_SECRET SET_RSA_PUBLIC_KEYS SET_RADM1 SET_RADM2";

const char pcomDefaultBuf[] = "G H I J K L M N O Q R W";


#include "Parameters.h"
#include <windows.h>

NppParameters * NppParameters::_pSelf = new NppParameters;

NppParameters::NppParameters():nbLang(0)
{
    _toolBarStatus = TB_LARGE;
    _statusBarShow = true;
    _splitterPos = POS_HORIZOTAL;
    _userDefineDlgStatus = /*0; UDD_SHOW |*/ UDD_DOCKED;

	for (int i = 0 ; i < NB_LANG ; _langList[i] = NULL, i++);

	//temporary
	_langList[0] = new Lang(LANG_C);
	_langList[0]->setWords(cInstrWords, LANG_INDEX_INSTR);
	_langList[0]->setWords(cTypeWords, LANG_INDEX_TYPE);
	nbLang++;

	_langList[1] = new Lang(LANG_CPP);
	_langList[1]->setWords(cppInstrWords, LANG_INDEX_INSTR);
	_langList[1]->setWords(cppTypeWords, LANG_INDEX_TYPE);
	nbLang++;

	_langList[2] = new Lang(LANG_JAVA);
	_langList[2]->setWords(javaInstrWords, LANG_INDEX_INSTR);
	_langList[2]->setWords(javaTypeWords, LANG_INDEX_TYPE);
	nbLang++;

    _langList[3] = new Lang(LANG_RC);
	_langList[3]->setWords(rcInstrWords, LANG_INDEX_INSTR);
	nbLang++;

    _langList[4] = new Lang(LANG_HTML);
	_langList[4]->setWords(htmlKeyWords, LANG_INDEX_INSTR);
	nbLang++;

    _langList[5] = new Lang(LANG_JS);
	_langList[5]->setWords(JSKeyWords, LANG_INDEX_INSTR);
	nbLang++;

    _langList[6] = new Lang(LANG_PHP);
	_langList[6]->setWords(PHPKeyWords, LANG_INDEX_INSTR);
	nbLang++;

    _langList[7] = new Lang(LANG_M30);
	_langList[7]->setWords(commandM30, LANG_INDEX_INSTR);
    _langList[7]->setWords(macroM30, LANG_INDEX_INSTR2);
    _langList[7]->setWords(commandLabel, LANG_INDEX_TYPE);
    _langList[7]->setWords(macroLabel, LANG_INDEX_TYPE2);
	nbLang++;

    _langList[8] = new Lang(LANG_PCOM);
	_langList[8]->setWords(pcomNativeCmd, LANG_INDEX_INSTR);
    _langList[8]->setWords(pcomExtCmd, LANG_INDEX_INSTR2);
    _langList[8]->setWords(pcomDefaultBuf, LANG_INDEX_TYPE);
	nbLang++;
}


void NppParameters::getWordList(std::string & wordList, int langID, int typeIndex) const
{
	Lang *pLang = getLangFromID(langID);
	if (!pLang)
	{
		::MessageBox(NULL, "langID n'existe pas! There will be no effect", "From getWordList()", MB_OK);
		return;
	}
    const char *str = pLang->getWords(typeIndex);
    if (!str)
    {
		::MessageBox(NULL, "There's no string in the index! no effect", "From getWordList()", MB_OK);
		return;
	}
	wordList = str;
}

void NppParameters::addWordList(std::string & wordList, int langID, int typeIndex) const
{
	Lang *pLang = getLangFromID(langID);
	if (!pLang)
	{
		::MessageBox(NULL, "langID n'existe pas! There will be no effect", "From addWordList()", MB_OK);
		return;
	}
    const char *str = pLang->getWords(typeIndex);
    if (!str)
    {
		::MessageBox(NULL, "There's no string in the index! no effect", "From addWordList()", MB_OK);
		return;
	}
    wordList.append(" ");
    wordList.append(str);
}
