#ifndef LASTRECENTFILELIST_H
#define LASTRECENTFILELIST_H

#include <list>
#include <string>

typedef std::list<std::string> stringList;

class LastRecentFileList
{
public :
	LastRecentFileList() : _userMax(10) {};
	void add(const char *fn) {
		if (int(_lrfl.size()) >= _userMax) return;
		_lrfl.push_back(fn);
	};
	void set(const char *fn) {
		if (find(fn)) 
			_lrfl.remove(fn);

		_lrfl.push_front(fn);

		if (int(_lrfl.size()) >= _userMax)
			_lrfl.pop_back();
	};
	void saveLRFL() const {
		for (stringList::const_iterator it = _lrfl.begin() ; it != _lrfl.end() ; it++)
		{
			//std::string str();
			//::MessageBox(NULL, str.c_str(), "saveLRFL", MB_OK);
			(NppParameters::getInstance())->writeHistory(((const std::string)*it).c_str());
		}
	};

	bool find(const char *fn) const {
		for (stringList::const_iterator it = _lrfl.begin() ; it != _lrfl.end() ; it++)
		{
			if (*it == fn)
			{
				//_lrfl.remove(*it);
				return true;
			}
		}
		return false;
	};
private:
	stringList _lrfl;
	int _userMax;
};

#endif //LASTRECENTFILELIST_H
