//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/*
// list MACOCS30 //
const char commandM30[] = "CALLFUNCTION CHECKSUM END ENTRANT GOTO LOCKREADER IF POWEROFF POWERON "
                          "SET SORTANT STATUSPERSO SWITCH UNLOCKREADER";

const char macroM30[]  = "ChangeCode CipherData CreateBinary CreateBinaryCipher CreateDirectoryV1 "
                         "CreateDirectoryV3 CreateFile CreateFilePlein00 CreateFilePleinFF CreateFileSMS "
                         "CreateFileVide CreateRecord CreateRecordCipher Delete DeleteFile DisableChv "
                         "EnableChv Envelope Fetch GenerateKey GetData GetResponse GetStatus Increase "
                         "Install InstallLoad Invalidate KeyCalculus LastLoad Load LockRecord "
                         "MultiCreateBinary MultiCreateRecord MultiLoad MultiUpdateBinary MultiUpdateRecord "
                         "PutData ReadBinary ReadDirectory ReadRecord Rehabilitate RsaInitKeyList RsaAddKeyToList "
                         "RsaSendRequest RsaGetPublicKeyVal RsaGetKeyModulusHash RsaGetAndCutPrivateKeyValue "
                         "RsaWritePrivateKey SetLock SetStatus SelectDF SelectEF Set Sleep StatusCard UpdateBinary "
                         "UpdateBinary2 UpdateRecord UnblockCode VerifyCode VerifyDisabled";

const char commandLabel[] = "ARG1 ARG2 CMD_ISO COMP CIBLE DATA DEST ELSE ETAT FREQ "
                            "IDFUNC LABEL OP PTS SECURITE SOURCE STATUS THEN";

const char macroLabel[] = "Blck Buf Cible CipherKey Cle ClearLen Code Compl CutLen "
                          "Data Dest Diversif DummyBuf ExponentVal FirstRec HiOffset "
                          "ID IndexInList KeyNumber Lg LgCre LgRec LgUp LoOffset "
                          "MaxLg Mode ModSel ModulusLen Nb NbRec NoRec Occur Offset Op "
                          "P1 P3 RBKey RBSize RecNum Source State Subset Target Tag1 Tag2 Type ULg";

// list Pcom //
const char pcomNativeCmd[] = "DEFINE POWER_ON POWER_OFF STEP_ON STEP_OFF LIST_ON LIST_OFF SET_BUFFER INSERT EJECT "
							 "ERROR_BEEP_ON ERROR_BEEP_OFF END_BEEP_ON END_BEEP_ON PATH READER CALL EXECUTE EXIT "
							 "BEGIN_LOOP LOOP INCREASE_BUFFER DECREASE_BUFFER APPEND_BUFFER UNDEFINE ALLUNDEFINE "
							 "IFDEF ELSE ENDIF IFNDEF LOAD UNLOAD";

const char pcomExtCmd[] = "SET_DATA DISPLAY COMPARE SET_RSA_LEN SET_RSA_NUB SET_RSA_NBITS COMPUTE_RSA_KEYS "
						  "GET_RSA_PUBLIC_KEYS GET_RSA_SIGNATURE VERIFY_RSA_SIGNATURE SHA SET_PRF_SECRET "
						  "SET_PRF_LABEL_SEED PRF SET_PRF_SECRET SET_RSA_PUBLIC_KEYS SET_RADM1 SET_RADM2";

const char pcomDefaultBuf[] = "G H I J K L M N O Q R W";
*/

#include "Parameters.h"
#include <windows.h>
#include <shlobj.h>

NppParameters * NppParameters::_pSelf = new NppParameters;

NppParameters::NppParameters():_nbLang(0), _nbFile(0), _pXmlDoc(NULL)
{
	// set the default values
	_nppGUI._toolBarStatus = TB_LARGE;
    _nppGUI._statusBarShow = true;
	_nppGUI._tabStatus = TAB_DRAWTOPBAR | TAB_DRAWINACTIVETAB | TAB_DRAGNDROP;
    _nppGUI._splitterPos = POS_HORIZOTAL;
    _nppGUI._userDefineDlgStatus = UDD_DOCKED;

	_svp[0]._lineNumberMarginShow = true;
	_svp[0]._bookMarkMarginShow = true;
	//_svp[0]._folderMarginShow = true;
	_svp[0]._folderStyle = FOLDER_STYLE_BOX;
	_svp[0]._indentGuideLineShow = true;
	//_svp[0]._invisibleCharsShow = false;

	_svp[1] = _svp[0];

	for (int i = 0 ; i < NB_LANG ; _langList[i] = NULL, i++);

	const int MAX_LEN = 256;
	char nppPath[MAX_LEN];
	char userPath[MAX_LEN];

	// langs.xml : for every user statically
	::GetModuleFileName(NULL, nppPath, sizeof(nppPath));
	PathRemoveFileSpec(nppPath);
	PathAppend(nppPath, "langs.xml");

	_pXmlDoc = new TiXmlDocument(nppPath);
	bool loadOkay = _pXmlDoc->LoadFile();
	if (!loadOkay)
	{
		::MessageBox(NULL, "Load langs.xml failed!", "Configurator",MB_OK);
		delete _pXmlDoc;
		_pXmlDoc = NULL;
	}
	else
		getLangKeywordsFromXmlTree();

	// config.xml : for per user
	SHGetFolderPath(NULL, CSIDL_APPDATA, NULL, 0/*SHGFP_TYPE_CURRENT*/, userPath);
	PathAppend(userPath, "Notepad++");
	if (!PathFileExists(userPath))
	{
		::CreateDirectory(userPath, NULL);
		//SHCreateDirectoryEx(NULL, userPath, NULL);
		//SHCreateDirectory(NULL, userPath);
	}
	PathAppend(userPath, "config.xml");
	if (!PathFileExists(userPath))
	{
		PathRemoveFileSpec(nppPath);
		PathAppend(nppPath, "config.xml");
		::CopyFile(nppPath, userPath, TRUE);
	}

	_pXmlUserDoc = new TiXmlDocument(userPath);
	bool loadOkay2 = _pXmlUserDoc->LoadFile();
	if (!loadOkay2)
	{
		::MessageBox(NULL, "Load config.xml failed!", "Configurator",MB_OK);
		delete _pXmlUserDoc;
		_pXmlUserDoc = NULL;
	}
	else
		getUserParametersFromXmlTree();
}

void NppParameters::getLangKeywordsFromXmlTree()
{
	TiXmlNode *root = _pXmlDoc->FirstChild("NotepadPlus");
		if (!root) return;
	feedKeyWordsParameters(root);
}

void NppParameters::getUserParametersFromXmlTree()
{
	if (!_pXmlDoc)
		return;

	TiXmlNode *root = _pXmlUserDoc->FirstChild("NotepadPlus");
	if (!root) return;

	// GUI
	feedGUIParameters(root);

	//History
	//Prendre toutes les allocation familliale de ses enfants
	feedFileListParameters(root);

	//Abondonner (ou plus radicalement, tuer) sa femme et ses enfants
	TiXmlNode *node = root->FirstChildElement("History");
	root->RemoveChild(node);

	//Trouver une jeune fille qui n'a pas d'enfant
	TiXmlElement HistoryNode("History");

	//se marrier avec cette jeune fille 
	root->InsertEndChild(HistoryNode);
}


void NppParameters::feedFileListParameters(TiXmlNode *node)
{
	if (_nbFile < NB_MAX_FILE)
	{
		TiXmlNode *historyRoot = node->FirstChildElement("History");
		if (!historyRoot) return;

		//TiXmlElement *element = node->ToElement();
		//int maxNbFile;
		//element->Attribute("MaxNbFile", &maxNbFile);

		for (TiXmlNode *childNode = historyRoot->FirstChildElement("File");
			childNode ;
			childNode = childNode->NextSibling("File") )
		{
			_LRFileList[_nbFile] = new std::string((childNode->FirstChild())->Value());
			_nbFile++;
		}
	}
}

void NppParameters::writeHistory(const char *fullpath)
{
	TiXmlNode *historyNode = (_pXmlUserDoc->FirstChild("NotepadPlus"))->FirstChildElement("History");
	TiXmlElement recentFileNode("File");
	TiXmlText fileNameFullPath(fullpath);
	recentFileNode.InsertEndChild(fileNameFullPath);

	(historyNode->ToElement())->InsertEndChild(recentFileNode);
}

int NppParameters::getLangIDFromStr(const char *langName) const
{
	std::string str(langName);
	if (str == "c")
		return LANG_C;
	else if (str == "cpp")
		return LANG_CPP;
	else if (str == "java")
		return LANG_JAVA;
	else if (str == "rc")
		return LANG_RC;
	else if (str == "html")
		return LANG_HTML;
	else if (str == "javascript")
		return LANG_JS;
	else if (str == "php")
		return LANG_PHP;
	else if (str == "macocs30")
		return LANG_M30;
	else if (str == "pcom")
		return LANG_PCOM;
	else
		return LANG_UNKNOWN;
}

int NppParameters::getIndexFromStr(const char *indexName) const
{
	std::string str(indexName);

	if (str == "instre1")
		return LANG_INDEX_INSTR;
	else if (str == "instre2")
		return LANG_INDEX_INSTR2;
	else if (str == "type1")
		return LANG_INDEX_TYPE;
	else if (str == "type2")
		return LANG_INDEX_TYPE2;
	else
		return -1;
}
 
void NppParameters::feedKeyWordsParameters(TiXmlNode *node)
{
	
	TiXmlNode *langRoot = node->FirstChildElement("Languages");
	if (!langRoot) return;

	for (TiXmlNode *langNode = langRoot->FirstChildElement("Language");
		langNode ;
		langNode = langNode->NextSibling("Language") )
	{
		if (_nbLang < NB_LANG)
		{
			TiXmlElement *element = langNode->ToElement();
			const char *name = element->Attribute("name");
			if (name)
			{
				_langList[_nbLang] = new Lang(getLangIDFromStr(name));

				for (TiXmlNode *kwNode = langNode->FirstChildElement("Keywords");
					kwNode ;
					kwNode = kwNode->NextSibling("Keywords") )
				{
					const char *indexName = (kwNode->ToElement())->Attribute("name");
					const char *keyWords = (kwNode->FirstChild())->Value();
					if ((indexName) && (keyWords))
						_langList[_nbLang]->setWords(keyWords, getIndexFromStr(indexName));
				}
				_nbLang++;
			}
		}
	}
}

void NppParameters::feedGUIParameters(TiXmlNode *node)
{
	TiXmlNode *GUIRoot = node->FirstChildElement("GUIConfigs");
	if (!GUIRoot) return;

	//TiXmlElement *element = GUIRoot->ToElement();

	for (TiXmlNode *childNode = GUIRoot->FirstChildElement("GUIConfig");
		childNode ;
		childNode = childNode->NextSibling("GUIConfig") )
	{
		TiXmlElement *element = childNode->ToElement();
		const char *nm = element->Attribute("name");
		if (!nm) return;

		//std::string name(nm);
		//std::string valueString;
		const char *val;

		if (!strcmp(nm, "ToolBar"))
		{
			val = (childNode->FirstChild())->Value();
			if (!val) return;

			if (!strcmp(val, "hide"))
				_nppGUI._toolBarStatus = TB_HIDE;
			else if (!strcmp(val, "small"))
				_nppGUI._toolBarStatus = TB_SMALL;
			else if (!strcmp(val, "large"))
				_nppGUI._toolBarStatus = TB_LARGE;
		}
		else if (!strcmp(nm, "StatusBar"))
		{
			val = (childNode->FirstChild())->Value();
			if (!val) return;

			if (!strcmp(val, "hide"))
				_nppGUI._statusBarShow = false;
			else if (!strcmp(val, "show"))
				_nppGUI._statusBarShow = true;
		}
		else if (!strcmp(nm, "TabBar"))
		{
			bool isFailed = false;
			int oldValue = _nppGUI._tabStatus;
			val = element->Attribute("dragAndDrop");
			if (val)
			{
				if (!strcmp(val, "yes"))
					_nppGUI._tabStatus = TAB_DRAGNDROP;
				else if (!strcmp(val, "no"))
					_nppGUI._tabStatus = 0;
				else
					isFailed = true;
			}

			val = element->Attribute("drawTopBar");
			if (val)
			{
				if (!strcmp(val, "yes"))
					_nppGUI._tabStatus |= TAB_DRAWTOPBAR;
				else if (!strcmp(val, "no"))
					_nppGUI._tabStatus |= 0;
				else
					isFailed = true;
			}
			val = element->Attribute("drawInactiveTab");
			if (val)
			{
				if (!strcmp(val, "yes"))
					_nppGUI._tabStatus |= TAB_DRAWINACTIVETAB;
				else if (!strcmp(val, "no"))
					_nppGUI._tabStatus |= 0;
				else
					isFailed = true;
			}

			if (isFailed)
				_nppGUI._tabStatus = oldValue;
		}

		else if (!strcmp(nm, "ScintillaViewsSplitter"))
		{
			val = (childNode->FirstChild())->Value();
			if (!val) return;

			//valueString = nm;
			if (!strcmp(val, "vertical"))
				_nppGUI._splitterPos = POS_VERTICAL;
			else if (!strcmp(val, "horizontal"))
				_nppGUI._splitterPos = POS_HORIZOTAL;
		}
		else if (!strcmp(nm, "UserDefineDlg"))
		{
			bool isFailed = false;
			int oldValue = _nppGUI._userDefineDlgStatus;

			val = (childNode->FirstChild())->Value();
			if (val) 
			{
				if (!strcmp(val, "hide"))
					_nppGUI._userDefineDlgStatus = 0;
				else if (!strcmp(val, "show"))
					_nppGUI._userDefineDlgStatus = UDD_SHOW;
				else 
					isFailed = true;
			}
			val = element->Attribute("position");
			if (val) 
			{
				if (!strcmp(val, "docked"))
					_nppGUI._userDefineDlgStatus |= UDD_DOCKED;
				else if (!strcmp(val, "undocked"))
					_nppGUI._userDefineDlgStatus |= 0;
				else 
					isFailed = true;
			}
			if (isFailed)
				_nppGUI._userDefineDlgStatus = oldValue;
		}
		else if (!strcmp(nm, "ScintillaPrimaryView"))
		{
            feedScintillaParam(SCIV_PRIMARY, element);
        }
		else if (!strcmp(nm, "ScintillaSecondaryView"))
		{
            feedScintillaParam(SCIV_SECOND, element);
        }
	}
}
void NppParameters::feedScintillaParam(bool whichOne, TiXmlNode *node)
{
    TiXmlElement *element = node->ToElement();
    //int index = (whichOne == SCIV_SECOND);

    // Line Number Margin
    const char *nm = element->Attribute("lineNumberMargin");
    if (!nm) return;

    //std::string valueString = nm;
	if (!strcmp(nm, "show"))
        _svp[whichOne]._lineNumberMarginShow = true;
	else if (!strcmp(nm, "hide"))
		_svp[whichOne]._lineNumberMarginShow = false;

    // Bookmark Margin
    nm = element->Attribute("bookMarkMargin");
    if (!nm) return;

	if (!strcmp(nm, "show"))
        _svp[whichOne]._bookMarkMarginShow = true;
	else if (!strcmp(nm, "hide"))
        _svp[whichOne]._bookMarkMarginShow = false;

    // Indent GuideLine 
    nm = element->Attribute("indentGuideLine");
    if (!nm) return;

	if (!strcmp(nm, "show"))
        _svp[whichOne]._indentGuideLineShow = true;
	else if (!strcmp(nm, "hide"))
        _svp[whichOne]._indentGuideLineShow= false;

    // Folder Mark Style
    nm = element->Attribute("folderMarkStyle");
    if (!nm) return;

	if (!strcmp(nm, "box"))
        _svp[whichOne]._folderStyle = FOLDER_STYLE_BOX;
	else if (!strcmp(nm, "circle"))
        _svp[whichOne]._folderStyle = FOLDER_STYLE_CIRCLE;
    else if (!strcmp(nm, "arrow"))
        _svp[whichOne]._folderStyle = FOLDER_STYLE_ARROW;
    else if (!strcmp(nm, "simple"))
        _svp[whichOne]._folderStyle = FOLDER_STYLE_SIMPLE;

}

void NppParameters::getWordList(std::string & wordList, int langID, int typeIndex) const
{
	Lang *pLang = getLangFromID(langID);
	if (!pLang)
	{
		//::MessageBox(NULL, "langID n'existe pas! There will be no effect", "From getWordList()", MB_OK);
		return;
	}


    const char *str = pLang->getWords(typeIndex);
    if (!str)
    {
		//::MessageBox(NULL, "There's no string in the index! no effect", "From getWordList()", MB_OK);
		return;
	}
    wordList = str;
}

void NppParameters::addWordList(std::string & wordList, int langID, int typeIndex) const
{
	Lang *pLang = getLangFromID(langID);
	if (!pLang)
	{
		//::MessageBox(NULL, "langID n'existe pas! There will be no effect", "From addWordList()", MB_OK);
		return;
	}
    const char *str = pLang->getWords(typeIndex);
    if (!str)
    {
		//::MessageBox(NULL, "There's no string in the index! no effect", "From addWordList()", MB_OK);
		return;
	}
    wordList.append(" ");
    wordList.append(str);
}
void NppParameters::writeGUIParams(const NppGUI & nppGUI) 
{
	TiXmlNode *GUIRoot = (_pXmlUserDoc->FirstChild("NotepadPlus"))->FirstChildElement("GUIConfigs");
	if (!GUIRoot) 
	{
		return;
	}
	for (TiXmlNode *childNode = GUIRoot->FirstChildElement("GUIConfig");
		childNode ;
		childNode = childNode->NextSibling("GUIConfig"))
	{
		TiXmlElement *element = childNode->ToElement();
		const char *nm = element->Attribute("name");
		if (!nm) {return;}

		if (!strcmp(nm, "ToolBar"))
		{
			const char *pStr = nppGUI._toolBarStatus == TB_HIDE?"hide":(nppGUI._toolBarStatus == TB_SMALL?"small":"large");
			(childNode->FirstChild())->SetValue(pStr);
		}
		else if (!strcmp(nm, "StatusBar"))
		{
			const char *pStr = nppGUI._statusBarShow?"show":"hide";
			(childNode->FirstChild())->SetValue(pStr);
		}
		else if (!strcmp(nm, "TabBar"))
		{
			const char *pStr = (nppGUI._tabStatus & TAB_DRAWTOPBAR)?"yes":"no";
			element->SetAttribute("dragAndDrop", pStr);

			pStr = (nppGUI._tabStatus & TAB_DRAGNDROP)?"yes":"no";
			element->SetAttribute("drawTopBar", pStr);

			pStr = (nppGUI._tabStatus & TAB_DRAWINACTIVETAB)?"yes":"no";
			element->SetAttribute("drawInactiveTab", pStr);
		}
		else if (!strcmp(nm, "ScintillaViewsSplitter"))
		{
			const char *pStr = nppGUI._splitterPos == POS_VERTICAL?"vertical":"horizontal";
			(childNode->FirstChild())->SetValue(pStr);
		}
		else if (!strcmp(nm, "UserDefineDlg"))
		{
			const char *pStr = nppGUI._userDefineDlgStatus & UDD_SHOW?"show":"hide";
			(childNode->FirstChild())->SetValue(pStr);
			
			pStr = (nppGUI._userDefineDlgStatus & UDD_DOCKED)?"docked":"undocked";
			element->SetAttribute("position", pStr);
		}
	}
}
