//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PARAMETERS_H
#define PARAMETERS_H

#include <string>
#include "tinyxml.h"
#include "ScintillaEditView.h"

//class TiXmlDocument;
//class TiXmlNode;
enum toolBarStatusType {TB_HIDE, TB_SMALL, TB_LARGE};

const bool POS_VERTICAL = true;
const bool POS_HORIZOTAL = false;

const int UDD_SHOW   = 1; // 0000 0001 
const int UDD_DOCKED = 2; // 0000 0010

// 0 : 0000 0000 hide & undocked
// 1 : 0000 0001 show & undocked
// 2 : 0000 0010 hide & docked
// 3 : 0000 0011 show & docked

const int TAB_DRAWTOPBAR = 1;      // 001
const int TAB_DRAWINACTIVETAB = 2; // 010
const int TAB_DRAGNDROP = 4;       // 100

const int LANG_C    = 0;
const int LANG_CPP  = 1;
const int LANG_JAVA = 2;
const int LANG_RC   = 3;
const int LANG_HTML = 4;
const int LANG_JS   = 5;
const int LANG_PHP  = 6;
const int LANG_ASP  = 7;
const int LANG_M30  = 8;
const int LANG_PCOM = 9;

const int LANG_UNKNOWN = 30;

const int LANG_INDEX_INSTR = 0;
const int LANG_INDEX_INSTR2 = 1;
const int LANG_INDEX_TYPE = 2;
const int LANG_INDEX_TYPE2 = 3;

const bool SCIV_PRIMARY = false;
const bool SCIV_SECOND = true;

struct NppGUI
{
	toolBarStatusType _toolBarStatus;		// small, large ou hide
	bool _statusBarShow;		// show ou hide

	// 1er  bit : draw top bar; 
	// 2nd  bit : draw inactive tabs
	// 3eme bit : enable drag&drop
	// 0:don't draw; 1:draw top bar 2:draw inactive tabs 3:draw both 7:draw both+drag&drop
	int _tabStatus;

	bool _splitterPos;			// horizontal ou vertical
	int _userDefineDlgStatus;	// (hide||show) && (docked||undocked)
};

struct ScintillaViewParams
{
	bool _lineNumberMarginShow;
	bool _bookMarkMarginShow;
	folderStyle  _folderStyle; //"simple", "arrow", "circle" and "box"
	bool _indentGuideLineShow;
};

const int NB_LIST = 20;
const int NB_MAX_FILE = 10;

struct Lang
{
	int _langID;
	const char *_langKeyWordList[NB_LIST];
	Lang() {for (int i = 0 ; i < NB_LIST ; _langKeyWordList[i] = NULL ,i++);};
	Lang(int langID) : _langID(langID){for (int i = 0 ; i < NB_LIST ; _langKeyWordList[i] = NULL ,i++);};
	~Lang() {};
	void setLangID(int langID){_langID = langID;};
	void setWords(const char *words, int index) {
		_langKeyWordList[index] = words;
	};
	const char * getWords(int index) const {
		return _langKeyWordList[index];
	};
};

const int NB_LANG = 32;
class NppParameters 
{
public:
    static NppParameters * getInstance() {return _pSelf;};
    void destroyInstance(){
		if (_pXmlDoc != NULL)
		{
			delete _pXmlDoc;
		}

		if (_pXmlUserDoc != NULL)
		{
			_pXmlUserDoc->SaveFile();
			delete _pXmlUserDoc;
		}
		delete _pSelf;
	};

	const NppGUI & getNppGUI() const {
        return _nppGUI;
    };

	/*
    toolBarStatusType getToolBarStatus() const {return _toolBarStatus;};
    bool willStatusBarBeShowed()  const {return _statusBarShow;};
	int getTabBarStatus() const {return _tabStatus;};
    bool getScintillaSplitterPos()  const {return _splitterPos;};
    int getUserDefineDlgStatus()  const {return _userDefineDlgStatus;};
	*/
	void getWordList(std::string & wordList, int langID, int typeIndex) const;
	void addWordList(std::string & wordList, int langID, int typeIndex) const;
	Lang * getLangFromID(int langID) const {
		for (int i = 0 ; i < _nbLang ; i++)
		{
			if ((_langList[i]->_langID == langID) || (!_langList[i]))
				return _langList[i];
		}
		return NULL;
	};

	int getNbLRFile() const {return _nbFile;};

	std::string *getLRFile(int index) const {
		return _LRFileList[index];
	};

    const ScintillaViewParams & getSVP(bool whichOne) const {
        return _svp[whichOne];
    };

	void writeHistory(const char *fullpath);

	TiXmlNode * getChildElementByAttribut(TiXmlNode *pere, const char *childName, 
											 const char *attributName, const char *attributVal) const {
		for (TiXmlNode *childNode = pere->FirstChildElement(childName);
			childNode ;
			childNode = childNode->NextSibling(childName))
		{
			TiXmlElement *element = childNode->ToElement();
			const char *val = element->Attribute(attributName);
			if (val)
			{
				if (!strcmp(val, attributVal))
					return childNode;
			}
		}
		return NULL;
	};
	//void folderStyleIntToStr(svp._folderStyle) const {

	//};

	void writeScintillaParams(const ScintillaViewParams & svp, bool whichOne) {
		const char *pViewName = (whichOne == SCIV_PRIMARY)?"ScintillaPrimaryView":"ScintillaSecondaryView";
		TiXmlNode *configsRoot = (_pXmlUserDoc->FirstChild("NotepadPlus"))->FirstChildElement("GUIConfigs");
		TiXmlNode *scintNode = getChildElementByAttribut(configsRoot, "GUIConfig", "name", pViewName);
		if (scintNode)
		{
			(scintNode->ToElement())->SetAttribute("lineNumberMargin", svp._lineNumberMarginShow?"show":"hide");
			(scintNode->ToElement())->SetAttribute("bookMarkMargin", svp._bookMarkMarginShow?"show":"hide");
			(scintNode->ToElement())->SetAttribute("indentGuideLine", svp._indentGuideLineShow?"show":"hide");
			const char *pFolderStyleStr = (svp._folderStyle == FOLDER_STYLE_SIMPLE)?"simple":
											(svp._folderStyle == FOLDER_STYLE_ARROW)?"arrow":
												(svp._folderStyle == FOLDER_STYLE_CIRCLE)?"circle":"box";
			(scintNode->ToElement())->SetAttribute("folderMarkStyle", pFolderStyleStr);
		}
		else {/*create one*/}
	};

	void writeGUIParams(const NppGUI & nppGUI);

private:
    NppParameters();
	~NppParameters() {
		for (int i = 0 ; i < _nbLang ; i++)
			delete _langList[i];
		for (int i = 0 ; i < _nbFile ; i++)
			delete _LRFileList[i];
	};
    static NppParameters *_pSelf;

	TiXmlDocument *_pXmlDoc, *_pXmlUserDoc;

	NppGUI _nppGUI;
	ScintillaViewParams _svp[2];
	Lang *_langList[NB_LANG];
	int _nbLang;

	std::string *_LRFileList[NB_MAX_FILE];
	int _nbFile;

	void getLangKeywordsFromXmlTree();
	void getUserParametersFromXmlTree();
	void feedGUIParameters(TiXmlNode *node);
	void feedKeyWordsParameters(TiXmlNode *node);
	void feedFileListParameters(TiXmlNode *node);
    void feedScintillaParam(bool whichOne, TiXmlNode *node);
	int getLangIDFromStr(const char *langName) const;
	int getIndexFromStr(const char *indexName) const;
};

#endif //PARAMETERS_H
