#ifndef WEBCONTROLCLASS_H
#define WEBCONTROLCLASS_H

extern "C" {
#include "WebCtrl.h"
}
#include "Window.h"

#define WEB_CTRL_CLASS_NAME "Web Control"

class WebControl : public Window
{
public :
	WebControl() : Window(){};
	void init(HINSTANCE, HWND);
    void displayPage(const char *addr) {
        DisplayHTMLPage(_hSelf, (LPSTR)addr);
    };
    
    void displayStr(const char *htmlStr) {
        DisplayHTMLStr(_hSelf, (LPSTR)htmlStr);
    };

    virtual void destroy() {
        ::DestroyWindow(_hSelf);
    };
	
private :
	static const char _className[32];
	static int _nbWindow;
	static LRESULT CALLBACK WebCtrl_Proc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
	LRESULT runProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
};



#endif WEBCONTROLCLASS_H
