//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "RunDlg.h"
#include "process.h"
#include "FileDialog.h"

BOOL CALLBACK RunDlg::run_dlgProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
		case WM_INITDIALOG :
		{
			getClientRect(_rc);
			return TRUE;
		}

		case WM_COMMAND : 
		{
			switch (wParam)
			{
				case IDCANCEL :
					display(false);
					return TRUE;
				
				case IDOK :
				{
					const int PATH_MAX_LEN = 256;
					char cmd[PATH_MAX_LEN];
					::GetDlgItemText(_hSelf, IDC_COMBO_RUN_PATH, cmd, PATH_MAX_LEN);
					//Process proggy(cmd, ".");
					//if (proggy.run() == TRUE)
					HINSTANCE hInst = ShellExecute(_hSelf, "open", cmd, NULL, ".", SW_SHOW);
					if (int(hInst) > 32)
					{
						addTextToCombo(cmd);
						display(false);
					}
					else
					{
						removeTextFromCombo(cmd);
					}
					return TRUE;
				}

				case IDC_BUTTON_FILE_BROWSER :
				{
					FileDialog fd(_hSelf, _hInst);
					fd.setExtFilter("Executable file : ", ".exe", ".com", ".cmd", ".bat", NULL);
					fd.setExtFilter("All files : ", ".*", NULL);

					if (stringVector *pfns = fd.doOpenDlg())
						addTextToCombo((pfns->at(0)).c_str());
					return TRUE;
				}

				default :
					break;
			}
		}
	}
	return FALSE;	
}

void RunDlg::addTextToCombo(const char *txt2Add) const
{
	HWND handle = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
	int i = ::SendMessage(handle, CB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)txt2Add);
	if (i == CB_ERR)
		i = ::SendMessage(handle, CB_ADDSTRING, 0, (LPARAM)txt2Add);
	::SendMessage(handle, CB_SETCURSEL, i, 0);
}
void RunDlg::removeTextFromCombo(const char *txt2Remove) const
{
	HWND handle = ::GetDlgItem(_hSelf, IDC_COMBO_RUN_PATH);
	int i = ::SendMessage(handle, CB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)txt2Remove);
	if (i == CB_ERR)
		return;
	::SendMessage(handle, CB_DELETESTRING, i, 0);
}

void RunDlg::doDialog()
{
	if (!isCreated())
		create(IDD_RUN_DLG);

    // Adjust the position of AboutBox
    RECT rc;
    ::GetClientRect(_hParent, &rc);
    POINT center;
    center.x = rc.left + (rc.right - rc.left)/2;
    center.y = rc.top + (rc.bottom - rc.top)/2;
    ::ClientToScreen(_hParent, &center);

    int x = center.x - _rc.right/2;
    int y = center.y - _rc.bottom/2;

    ::SetWindowPos(_hSelf, HWND_TOP, x, y, _rc.right, _rc.bottom, SWP_SHOWWINDOW);
    
};
