//this file is part of notepad++
//Copyright (C)2003 Don HO ( donho@altern.org )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "PluginsManager.h"


bool PluginsManager::loadPlugins()
{
	vector<string> dllNames;
	const char *pNppPath = (NppParameters::getInstance())->getNppPath();

	string pluginsFullPathFilter = pNppPath;
	pluginsFullPathFilter += "\\plugins\\*.dll";

	WIN32_FIND_DATA foundData;
	HANDLE hFindFile = ::FindFirstFile(pluginsFullPathFilter.c_str(), &foundData);
	if (hFindFile != INVALID_HANDLE_VALUE)
	{
		string plugins1stFullPath = pNppPath;
		plugins1stFullPath += "\\plugins\\";
		plugins1stFullPath += foundData.cFileName;
		dllNames.push_back(plugins1stFullPath);

		while (::FindNextFile(hFindFile, &foundData))
		{
			string fullPath = pNppPath;
			fullPath += "\\plugins\\";
			fullPath += foundData.cFileName;
			dllNames.push_back(fullPath);
		}
		::FindClose(hFindFile);

		for (size_t i = 0 ; i < dllNames.size() ; i++)
		{
			PluginInfo *pi = new PluginInfo;
			try {
				pi->_hLib = ::LoadLibrary(dllNames[i].c_str());
				if (!pi->_hLib)
					throw string("Load Library is failed");

				pi->_pFuncSetInfo = (PFUNCSETINFO)GetProcAddress(pi->_hLib, "setInfo");
							
				if (!pi->_pFuncSetInfo)
					throw string("missing \"setInfo\" function");

				pi->_pFuncGetName = (PFUNCGETNAME)GetProcAddress(pi->_hLib, "getName");
				if (!pi->_pFuncGetName)
					throw string("missing \"getName\" function");

				pi->_pBeNotified = (PBENOTIFIED)GetProcAddress(pi->_hLib, "beNotified");
				if (!pi->_pBeNotified)
					throw string("missing \"beNotified\" function");

				pi->_pFuncGetFuncsArray = (PFUNCGETFUNCSARRAY)GetProcAddress(pi->_hLib, "getFuncsArray");
				if (!pi->_pFuncGetFuncsArray) 
					throw string("missing \"getFuncsArray\" function");

				pi->_funcItems = pi->_pFuncGetFuncsArray(&pi->_nbFuncItem);

				if ((!pi->_funcItems) || (pi->_nbFuncItem <= 0))
					throw string("missing \"FuncItems\" array, or the nb of Function Item is not set correctly");

				for (int i = 0 ; i < pi->_nbFuncItem ; i++)
					if (!pi->_funcItems[i]._pFunc)
						throw string("\"FuncItems\" array is not set correctly");

				pi->_pluginMenu = ::CreateMenu();
				
				pi->_pFuncSetInfo(_nppData);

				_pluginInfos.push_back(pi);
				
			}
			catch(string s)
			{
				::MessageBox(NULL, s.c_str(), foundData.cFileName, MB_OK);
				delete pi;
			}
			catch(...)
			{
				::MessageBox(NULL, "Fail loaded", foundData.cFileName, MB_OK);
				delete pi;
			}
		}
	}

	//pi._pFuncSetInfo(_nppData);
	//const char * pluginName = _pFuncGetName(); 
	return true;
}
